# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines the base CLI mode for defining L1 card profiles through the
CLI.
'''

from Plugins import SkipPluginModule
from Toggles import L1ProfileToggleLib
import CliMode

if not L1ProfileToggleLib.toggleL1ProfileCustomModuleSupportEnabled():
   raise SkipPluginModule( 'L1 Profiles Custom Module Toggle Not Enabled' )

class CardProfileDefinitionMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'l1 module profile {self.param_}'

   def __init__( self, param ):
      self.modeKey = 'l1-module-profile'
      self.longModeKey = f'{self.modeKey}-{param}'
      CliMode.ConfigMode.__init__( self, param )
