#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF
DEFAULT_LDAP_PORT = 389

class ServerConfigModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      if isinstance( self.param_, str ):
         return f'server {self.param_}'
      else:
         cmd = f'server host {self.param_.hostname}'
         if self.param_.port != DEFAULT_LDAP_PORT:
            cmd += f' port {self.param_.port}'
         if self.param_.vrf != DEFAULT_VRF:
            cmd += f' vrf {self.param_.vrf}'
         return cmd

   def __init__( self, label ):
      self.modeKey = 'ldap'

      if isinstance( label, str ):
         self.longModeKey = f'ldap-{label}'
      else:
         portStr = f':{label.port}' if label.port != DEFAULT_LDAP_PORT else ''
         vrfStr = f'[vrf{label.vrf}]' if label.vrf != DEFAULT_VRF else ''
         self.longModeKey = f'ldap-host-{label.hostname}{portStr}{vrfStr}'
      CliMode.ConfigMode.__init__( self, label )

class GroupPolicyConfigModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'group policy {self.param_}'

   def __init__( self, param ):
      self.modeKey = 'mgmt-ldap-gp'
      self.longModeKey = f'mgmt-ldap-gp-{param}'
      CliMode.ConfigMode.__init__( self, param )

class LdapServerGroupModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'aaa group server ldap {self.param_}'

   def __init__( self, param ):
      self.modeKey = "sg-ldap"
      self.longModeKey = f"sg-ldap-{param}"
      CliMode.ConfigMode.__init__( self, param )
