#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class LinkFlapMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'monitor link-flap policy'

   def __init__( self, param ):
      self.modeKey = "link-flap"
      self.longModeKey = "link-flap"
      CliMode.ConfigMode.__init__( self, param )

class LinkFlapDampingMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'profile {self.profileName} damping'

   def __init__( self, param ):
      self.profileName = param
      self.modeKey = f'link-flap-damping-profile-{self.profileName}'
      self.longModeKey = f'link-flap-damping-profile-{self.profileName}'
      CliMode.ConfigMode.__init__( self, param )
