#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.MaintenanceMode import MaintenanceMode

class MaintenanceBuiltinUnitMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'unit %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = 'builtin-unit'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'builtin-unit-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )

   def commentKey( self ):
      # CliSave modes do not distinguish between built-in and non built-in modes
      return f'unit-{self.param_}'
