#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.MaintenanceMode import MaintenanceMode

class MaintenanceUnitProfileMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'profile unit %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'profile-unit'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'profile-unit-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )
