# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class McastDnsMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'mdns'

   def __init__( self ):
      self.modeKey = 'mdns'
      self.longModeKey = 'mdns'
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class McastDnsServiceMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'service %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, serviceName ):
      self.modeKey = 'mdns-service'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'mdns-service-%s' % serviceName
      CliMode.ConfigMode.__init__( self, serviceName, parentMode=McastDnsMode )
