# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class McsServiceClientMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "mcs client"

   def __init__( self, param ):
      self.modeKey = "mcs-client"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )

class McsServiceClientSecondaryCvxMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      if self.param_:
         # pylint: disable-next=consider-using-f-string
         return "cvx secondary %s" % self.param_
      else:
         return "cvx secondary"


   def __init__( self, param ):
      if not param:
         self.modeKey = "mcs-client-cvx"
      else:
         # pylint: disable-next=consider-using-f-string
         self.modeKey = "mcs-client-cvx-%s" % param
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=McsServiceClientMode )
