#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class ManagementMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = "mgmt"
      self.longModeKey = "mgmt-%s" % param # pylint: disable=consider-using-f-string
      CliMode.ConfigMode.__init__( self, param )
