#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingMulticastMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router multicast'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-multicast'
      CliMode.ConfigMode.__init__( self, param )

class RoutingMulticastVrfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      assert param != DEFAULT_VRF
      self.modeKey = 'router'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'router-multicast-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingMulticastMode )

class RoutingMulticastAfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return str( self.af )

   def __init__( self, vrfName, af ):
      self.modeKey = 'router'
      self.af = af
      self.vrfName = vrfName
      if vrfName == DEFAULT_VRF:
         # pylint: disable-next=consider-using-f-string
         self.longModeKey = 'router-multicast-%s' % af
      else:
         # pylint: disable-next=consider-using-f-string
         self.longModeKey = 'router-multicast-vrf-%s-%s' % ( vrfName, af )

      CliMode.ConfigMode.__init__( self, ( vrfName, af ) )

class RoutingMulticastAfMplsStaticTunnelMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return ( f"mpls tunnel static{' ' if self._group else ''}{self._group}"
               f"{' ' if self._source else ''}{self._source}" )

   def __init__( self, vrfName, af, source, group ):
      self.modeKey = 'router'
      self.af = af
      self._source = '' if source.isAddrZero else source.stringValue
      self._group = '' if group.isAddrZero else group.stringValue
      self.vrfName = vrfName

      if vrfName == DEFAULT_VRF:
         self.longModeKey = f'router-multicast-{af}-mpls-tunnel-static'
      else:
         self.longModeKey = \
              f'router-multicast-vrf-{vrfName}-{af}-mpls-tunnel-static'

      self.longModeKey = \
         ( f"{self.longModeKey}{'-' if self._group else ''}"
           f"{self._group}{'-' if self._source else ''}{self._source}" )

      CliMode.ConfigMode.__init__( self, ( vrfName, af, source, group ) )



