# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliMode

class MssMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'service mss'

   def __init__( self ):
      self.modeKey = 'cvx-mss'
      self.longModeKey = 'cvx-mss'
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class MssStaticDeviceMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'static device %s' % self.param_

   def __init__( self, param ):
      self.deviceName = param
      self.modeKey = 'cvx-mss-sd-%s' % param
      self.longModeKey = 'cvx-mss-sd-%s' % param
      CliMode.ConfigMode.__init__( self, param )

class MssStaticVrfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'vrf %s' % self.vrfName

   def __init__( self, param ):
      self.deviceName = param[ 0 ]
      self.vrfName = param[ 1 ]
      self.modeKey = f'cvx-mss-sd-{self.deviceName}-{self.vrfName}'
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=MssStaticDeviceMode )

class MssStaticL3NextHopMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'next-hop address ipv4 %s' % self.ipv4

   def __init__( self, param ):
      self.deviceName = param[ 0 ]
      self.vrfName = param[ 1 ]
      self.ipv4 = param[ 2 ]
      self.modeKey = f'cvx-mss-sd-{self.deviceName}-{self.vrfName}-ipv4'
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=MssStaticVrfMode )

   def commentKey( self ):
      return f'cvx-mss-sd-{self.deviceName}-{self.vrfName}-{self.ipv4}'

class MssStaticL3PolicyMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'traffic-policy'

   def __init__( self, param ):
      self.deviceName = param[ 0 ]
      self.vrfName = param[ 1 ]
      self.modeKey = f'cvx-mss-sd-{self.deviceName}-{self.vrfName}-policy'
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=MssStaticVrfMode )

class MssStaticRuleMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'match %s ipv4' % self.ruleName

   def __init__( self, param ):
      self.deviceName = param[ 0 ]
      self.vrfName = param[ 1 ]
      self.ruleName = param[ 2 ]
      self.modeKey = 'cvx-mss-sd-{}-{}-{}'.format( self.deviceName, self.vrfName,
                                                   self.ruleName )
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param, parentMode=MssStaticL3PolicyMode )
