# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.BgpCommon import RoutingBgpVrfMode

class MvpnIpv4VrfMode( CliMode.ConfigMode ):
   name = 'mvpn ipv4 configuration'

   def enterCmd( self ):
      cmd = 'mvpn-ipv4'
      return cmd

   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = 'mvpn-ipv4-vrf'
      self.longModeKey = f'mvpn-ipv4-vrf-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBgpVrfMode )

class MvpnIpv4VrfSpmsiMode( CliMode.ConfigMode ):
   name = 'mvpn ipv4 selective-pmsi configuration'

   def enterCmd( self ):
      cmd = 'selective-pmsi'
      return cmd

   def __init__( self, param ):
      self.vrfName_ = param
      self.modeKey = 'selective-pmsi-vrf'
      self.longModeKey = f'selective-pmsi-vrf-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBgpVrfMode )

class MvpnIpv4VrfIntraAsIPmsiMode( CliMode.ConfigMode ):
   name = 'mvpn ipv4 intra-as-ipmsi configuration'

   def enterCmd( self ):
      cmd = 'intra-as-ipmsi'
      return cmd

   def __init__( self, param ):
      self.vrfName_ = param
      self.modeKey = 'intra-as-ipmsi-vrf'
      self.longModeKey = f'intra-as-ipmsi-vrf-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBgpVrfMode )
