#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliMode
from IpLibConsts import DEFAULT_VRF

class NatPoolMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'ip nat pool %s ' % ( "%s prefix-length %d" % ( self.poolName,
         self.prefixLen ) )

   def __init__( self, param ):
      ( self.poolName, self.prefixLen ) = param
      self.modeKey = "nat-pool"
      self.longModeKey = "natpool-%s" % self.poolName
      CliMode.ConfigMode.__init__( self, self.poolName )

class NatPortOnlyPoolMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'ip nat pool %s port-only' % self.poolName

   def __init__( self, param ):
      self.poolName = param
      self.modeKey = "nat-pool"
      self.longModeKey = "natpool-%s" % self.poolName
      CliMode.ConfigMode.__init__( self, self.poolName )

class NatSyncMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'ip nat synchronization'

   def __init__( self, param=None ):
      self.modeKey = 'nat-sync'
      self.longModeKey = 'nat-synchronization'
      CliMode.ConfigMode.__init__( self, 'nat-sync' )

class NatProfileMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      cmd = 'ip nat profile %s' % self.profileName
      if self.vrfName != DEFAULT_VRF:
         cmd += ' vrf %s' % self.vrfName
      return cmd

   def __init__( self, param ):
      ( self.profileName, self.vrfName ) = param
      self.modeKey = "nat-profile"
      self.longModeKey = "nat-profile-%s" % self.profileName
      CliMode.ConfigMode.__init__( self, param )

class NatFlowMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'ip nat flow'

   def __init__( self, param=None ):
      self.modeKey = 'nat-flow'
      self.longModeKey = 'nat-flow-policies'
      CliMode.ConfigMode.__init__( self, 'nat-flow' )

class NatFlowPolicyMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'policy %s' % self.natFlowPolicyName

   def __init__( self, param ):
      self.parentMode, self.natFlowPolicyName = param
      self.modeKey = 'nat-flow'
      self.longModeKey = 'nat-flow-policy-%s' % self.natFlowPolicyName
      CliMode.ConfigMode.__init__( self, param, parentMode=self.parentMode )

class NatFlowMatchMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      cmd = 'match %s' % self.matchName
      return cmd

   def __init__( self, param ):
      ( self.parentMode, self.natFlowPolicyName, self.matchName ) = param
      self.modeKey = 'match-%s' % self.matchName
      self.longModeKey = 'nat-flow-policy-%s-match-%s' % \
            ( self.natFlowPolicyName, self.matchName )
      CliMode.ConfigMode.__init__( self, param, parentMode=self.parentMode )

class NatFlowActionMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      cmd = 'action %s' % self.actionName
      return cmd

   def __init__( self, param ):
      ( self.parentMode, self.natFlowPolicyName, self.matchName, 
            self.actionName ) = param
      self.modeKey = 'action %s' % self.actionName
      self.longModeKey = 'nat-flow-policy-%s-match-%s-action-%s' % \
            ( self.natFlowPolicyName, self.matchName, self.actionName )
      CliMode.ConfigMode.__init__( self, param, parentMode=self.parentMode )
