#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class NatServiceListMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'ip nat service-list %s' % self.serviceListName

   def __init__( self, serviceListName ):
      self.serviceListName = serviceListName
      self.modeKey = "nat-service-list"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "nat-service-list-%s" % self.serviceListName
      CliMode.ConfigMode.__init__( self, self.serviceListName )
