# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode import (
   ConfigMode,
   )
from TypeFuture import (
   TacLazyType,
   )

IntfId = TacLazyType( 'Arnet::IntfId' )

class NeighborResolutionMode( ConfigMode ):
   def __init__( self ):
      self.modeKey = 'nbr-res'
      self.longModeKey = 'nbr-res'
      ConfigMode.__init__( self, param=None )

   def enterCmd( self ):
      return 'neighbor resolution'

class NeighborResolutionIntfMode( ConfigMode ):
   def __init__( self, intfId ):
      '''
      intfId is ether an Arnet::IntfId or a str
      '''
      self.modeKey = 'nbr-res-if'
      self.longModeKey = f'nbr-res-if-{self.shortName(intfId)}'
      ConfigMode.__init__( self, param=intfId, parentMode=NeighborResolutionMode )

   def enterCmd( self ):
      return f'interface {self.longName(self.param_)}'

   @staticmethod
   def longName( intfId ):
      if isinstance( intfId, str):
         return intfId
      return intfId.stringValue

   @staticmethod
   def shortName( intfId ):
      if isinstance( intfId, str ):
         try:
            intfId = IntfId( intfId )
         except IndexError:
            # could not convert to an Arnet::IntfId
            # so just return the string given to us
            return intfId
      return intfId.shortName or intfId.stringValue
