#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MgmtNetconfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management api netconf'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'mgmt-api-netconf'
      CliMode.ConfigMode.__init__( self, param )

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return f'mgmt-{cls.__name__}'

class NetconfTransportMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'transport ssh {self.param_}'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = f'netconf-transport-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtNetconfMode )
