#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class OcspProfileMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"ocsp profile {self.param_}"

   def __init__( self, param ):
      self.modeKey = "mgmt-sec-ocsp-profile"
      self.longModeKey = f"mgmt-sec-ocsp-profile-{param}"
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=CliMode.Mgmt.ManagementMode )
