#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class OpenFlowMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'openflow'

   def __init__( self, param ):
      self.modeKey = "openflow"
      self.longModeKey = "openflow"
      CliMode.ConfigMode.__init__( self, param )

class FlowEntryCMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "flow %s" % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = "openflow-flow"
      tmp = param.split()[0]
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "openflow-%s" % tmp
      CliMode.ConfigMode.__init__( self, param )

class ControllerMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return "controller %s" % self.controller

   def __init__( self, param ):
      self.modeKey = "openflow-controller"
      self.controller = param
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "openflow-%s" % self.controller.split( ':', 1 )[ 1 ]
      CliMode.ConfigMode.__init__( self, self.longModeKey, parentMode=OpenFlowMode )
