# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
#
# Profiles sub-mode.
#
class ProfilesMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "phy transmitter equalization profiles"
   def __init__( self ):
      self.modeKey = "phy-tx-eq-profile"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None )
#
# Profile sub-mode.
#
class ProfileMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"profile {self.param}"
   def __init__( self, param ):
      self.param = param
      self.modeKey = "profile"
      self.longModeKey = f"phy-tx-eq-profile-{self.param}"
      CliMode.ConfigMode.__init__( self, None )
#
# Taps sub-mode.
#
class TapsMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "taps"
   def __init__( self, param ):
      self.param = param
      self.modeKey = "taps"
      self.longModeKey = f"phy-tx-eq-profile-{self.param}-taps"
      CliMode.ConfigMode.__init__( self, None )
