# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Cli config modes used for configuring common pseudowire profiles (see AID10962),
# for example:
#    mpls pseudowires
#       profiles
#          profile PROFILE_1
#             control-word
#             mtu 9000
#             pseudowire-type raw
#             label flow transmit

import CliMode
from CliMode.Pseudowire import MplsPseudowiresMode

# Cli mode for configuring MPLS pseudowire profiles.
class MplsPseudowireProfilesMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = "mpls-pw-pf"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None, parentMode=MplsPseudowiresMode )

   def enterCmd( self ):
      return "profiles"

# Cli mode for configuring an individual MPLS pseudowire profile.
class MplsPseudowireProfileMode( CliMode.ConfigMode ):
   def __init__( self, profileName ):
      self.profileName = profileName
      self.modeKey = "mpls-pw-pf-" + self.profileName
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, self.profileName,
                                   parentMode=MplsPseudowireProfilesMode )

   def enterCmd( self ):
      return "profile " + self.profileName
