#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.ContainerMgrMode import ContainerMgrMode

class RegistryMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'registry %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = 'container-mgr-registry'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'container-mgr-registry-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=ContainerMgrMode )
