#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MgmtRestconfMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management api restconf'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'mgmt-api-restconf'
      CliMode.ConfigMode.__init__( self, param )

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return f'mgmt-{cls.__name__}'

class RestconfTransportMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'transport https {self.param_}'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = f'restconf-transport-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtRestconfMode )
