# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliMode

class RsvpMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'mpls rsvp'

   def __init__( self ):
      self.modeKey = "mpls-rsvp"
      self.longModeKey = "mpls-rsvp"
      CliMode.ConfigMode.__init__( self, 'rsvp' )

   def skipIfEmpty( self ):
      return True

class HitlessRestartMode( CliMode.ConfigMode ):
   '''Hitless Restart is a child mode of rsvp'''

   def enterCmd( self ):
      return 'hitless-restart'

   def __init__( self ):
      key = 'mpls-rsvp-hr'
      self.modeKey = key
      self.longModeKey = key
      CliMode.ConfigMode.__init__( self, 'hitlessRestart', parentMode=RsvpMode )

class GrHelperMode( CliMode.ConfigMode ):
   '''gr helper will be a child mode of rsvp'''

   def enterCmd( self ):
      return 'graceful-restart role helper'

   def __init__( self ):
      key = 'mpls-rsvp-gr-helper'
      self.modeKey = key
      self.longModeKey = key
      CliMode.ConfigMode.__init__( self, 'grHelper', parentMode=RsvpMode )

class GrSpeakerMode( CliMode.ConfigMode ):
   '''gr speaker will be a child mode of rsvp'''

   def enterCmd( self ):
      return 'graceful-restart role speaker'

   def __init__( self ):
      key = 'mpls-rsvp-gr-speaker'
      self.modeKey = key
      self.longModeKey = key
      CliMode.ConfigMode.__init__( self, 'grSpeaker', parentMode=RsvpMode )

class RsvpP2mpMode( CliMode.ConfigMode ):
   '''p2mp mode is a child mode of rsvp'''

   def enterCmd( self ):
      return 'p2mp'

   def __init__( self ):
      key = 'mpls-rsvp-p2mp'
      self.modeKey = key
      self.longModeKey = key
      CliMode.ConfigMode.__init__( self, 'p2mp', parentMode=RsvpMode )
