# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Classification import ( ClassificationConfigModeBase )
from CliMode.TrafficPolicy import ( MatchRuleBaseConfigMode, ActionsConfigModeBase )

class SamplePolicyModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"sample policy {self.trafficPolicyName}"

   def __init__( self, param ):
      self.feature, self.parentMode, self.trafficPolicyName = param
      self.modeKey = "sample-policy"
      self.longModeKey = f"{self.feature}-{self.trafficPolicyName}"
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=self.parentMode )
      self.trafficPolicyContext = None

   def getContext( self ):
      return self.trafficPolicyContext

   def setContext( self, value ):
      self.trafficPolicyContext = value

class SamplePolicyConfigModeBase( SamplePolicyModeBase,
                                  ClassificationConfigModeBase ):

   def __init__( self, parent, session, context, feature ):
      SamplePolicyModeBase.__init__( self, ( feature, type( parent ),
                                             context.pmapName() ) )
      ClassificationConfigModeBase.__init__( self, parent, session )
      self.trafficPolicyContext = context
      self.trafficPolicy = context.currentPolicy()
      context.modeIs( self )

# Configuration mode for sample-policy
class SamplePolicyConfigMode( SamplePolicyConfigModeBase,
                              ClassificationConfigModeBase ):
   name = "sample-policy configuration"
   l4PortSaveAll = False

# Match rule configuration mode
class SamplePolicyMatchRuleConfigMode( MatchRuleBaseConfigMode ):
   name = 'sample-policy match rule configuration'
   l4PortSaveAll = False

# Action configuration mode
class SamplePolicyActionRuleConfigMode( ActionsConfigModeBase ):
   name = 'sample-policy action rule configuration'
   l4PortSaveAll = False
