# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import BasicCli
from Arnet import IntfId

class PortConfigModeBase( CliMode.ConfigMode ):
   ''' Configuration mode for Sfe hardware interface '''
   def enterCmd( self ):
      return 'platform sfe port'

   def __init__( self ):
      self.modeKey = "port"
      self.longModeKey = "platform-sfe-port"
      CliMode.ConfigMode.__init__( self, self.longModeKey )

   def onExit( self ):
      print( "Please save your config and reload the system of restart"
            " Sfe agent for your changes to take effect." )
      BasicCli.ConfigModeBase.onExit( self )

class PortProfileModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f'profile {self.profileName}'

   def __init__( self, param ):
      self.profileName = param
      self.modeKey = "port-profile"
      self.longModeKey = f"port-profile-{self.profileName}"
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=PortConfigModeBase )

class PortIntfModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f'interface { self.intfName }'

   def __init__( self, profileName, intfName ):
      self.intfName = intfName
      self.modeKey = 'port-profile-if'
      self.longModeKey =\
            f'port-profile-{profileName}-if-{IntfId( intfName ).shortName}'
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=PortProfileModeBase )
