#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class RoutingSrv6Mode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "router segment-routing ipv6"

   def __init__( self, param=None ):
      self.modeKey = "router"
      self.longModeKey = "router-srv6"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return "router-srv6"

class RoutingSrv6VrfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'vrf %s' % self.vrfName

   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = 'router'
      self.longModeKey = 'router-srv6-vrf-%s' % self.vrfName
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingSrv6Mode )

   def commentKey( self ):
      return 'router-srv6-vrf-%s' % self.vrfName

class RoutingSrv6VrfUsidDomainMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'micro-segment domain %s' % self.domain

   def __init__( self, param ):
      self.vrfName, self.domain = param
      self.modeKey = 'router'
      self.longModeKey = 'router-srv6-vrf-%s-domain' % self.vrfName
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingSrv6VrfMode )

   def commentKey( self ):
      return 'router-srv6-vrf-%s-domain-%s' % ( self.vrfName, self.domain )

class RoutingSrv6VrfLocatorMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'locator %s' % self.locator

   def __init__( self, param ):
      self.vrfName, self.locator = param
      self.modeKey = 'router'
      self.longModeKey = 'router-srv6-vrf-%s-locator' % self.vrfName
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingSrv6VrfMode )

   def commentKey( self ):
      return 'router-srv6-vrf-%s-locator-%s' % ( self.vrfName, self.locator )
