# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Upnp import UpnpMode

class SsdpMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = "upnp-ssdp"
      self.longModeKey = "upnp-ssdp"
      CliMode.ConfigMode.__init__( self, None, parentMode=UpnpMode )

   def enterCmd( self ):
      return "ssdp"

   def skipIfEmpty( self ):
      return True

class SsdpVrfMode( CliMode.ConfigMode ):
   def __init__( self, vrfName ):
      self.vrfName = vrfName
      self.modeKey = "upnp-ssdp-vrf-%s" % vrfName
      self.longModeKey = "upnp-ssdp-vrf-%s" % vrfName
      CliMode.ConfigMode.__init__( self, vrfName, parentMode=SsdpMode )

   def enterCmd( self ):
      return "vrf %s" % self.vrfName

   def skipIfEmpty( self ):
      return True
