#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class SshAuthenticationX509Mode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "authentication x509"

   def __init__( self ):
      self.modeKey = "mgmt-ssh-auth-x509"
      self.longModeKey = "mgmt-ssh-auth-x509"
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

   def skipIfEmpty( self ):
      # Don't show mode in outputs if it has no commands added to it
      return True
