# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class SshUserMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f"username {self.userName}"

   def __init__( self, param ):
      self.userName = param
      self.modeKey = "mgmt-ssh-user"
      self.longModeKey = f"mgmt-ssh-user-{self.userName}"
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=CliMode.ConfigMode )

class SshKeyMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"ssh-key {self.keyName_}"

   def __init__( self, param ):
      self.modeKey = f"mgmt-ssh-user-{param[ 0 ]}-{param[ 1 ]}"
      self.keyName_ = param[ 1 ]
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=SshUserMode )

class SshPrincipalMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f"ssh-principal {self.principal_}"

   def __init__( self, param ):
      self.modeKey = f"mgmt-ssh-user-{param[ 0 ]}-{param[ 1 ]}"
      self.principal_ = param[ 1 ]
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=SshUserMode )
