#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class StunBaseMode( CliMode.ConfigMode ):
   """
   CLI mode base class for:
   (config)#stun
   """

   def enterCmd( self ):
      return "stun"

   def __init__( self ):
      self.modeKey = "stun"
      self.longModeKey = "stun"
      CliMode.ConfigMode.__init__( self, None )

class StunServerBaseMode( CliMode.ConfigMode ):
   """
   CLI mode base class for:
   (config-stun)#server
   """

   def enterCmd( self ):
      return "server"

   def __init__( self ):
      self.modeKey = "server"
      self.longModeKey = "stun-server"
      CliMode.ConfigMode.__init__( self, None, parentMode=StunBaseMode )

class StunClientBaseMode( CliMode.ConfigMode ):
   """
   CLI mode base class for:
   (config-stun)#client
   """

   def enterCmd( self ):
      return "client"

   def __init__( self ):
      self.modeKey = "client"
      self.longModeKey = "stun-client"
      CliMode.ConfigMode.__init__( self, None, parentMode=StunBaseMode )

class StunServerProfileBaseMode( CliMode.ConfigMode ):
   """
   CLI mode base class for:
   (config-stun)#server-profile < name >
   """

   def enterCmd( self ):
      return "server-profile %s" % self.param_

   def __init__( self, param ):
      self.modeKey = "server-profile"
      self.longModeKey = "stun-server-profile"
      CliMode.ConfigMode.__init__( self, param, parentMode=StunClientBaseMode )

