#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class SwagMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'switch aggregation'

   def __init__( self, param ):
      self.modeKey = "switch-aggregation"
      self.longModeKey = "switch-aggregation"
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )

class SwagTopoMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'topology'

   def __init__( self, param ):
      self.modeKey = "switch-aggregation-topo"
      self.longModeKey = "switch-aggregation-topo"
      CliMode.ConfigMode.__init__( self, param, parentMode=SwagMode )

class SwagTopoMemberMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return f'member {self.memberId}'

   def __init__( self, param ):
      self.memberId = param
      self.modeKey = 'switch-aggregation-topo-member'
      self.longModeKey = f'switch-aggregation-topo-member-{self.memberId}'
      CliMode.ConfigMode.__init__( self, param, parentMode=SwagTopoMode )
