#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliMode

class TapAggMode( CliMode.ConfigMode ):
   
   def enterCmd( self ):
      return 'tap aggregation'

   def __init__( self, param ):
      # self.modeKey = 'tap-agg'
      self.longModeKey = 'tap-agg' 
      CliMode.ConfigMode.__init__( self, param )

class TapAggActionModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'action %s' % self.aName

   def __init__( self, param ):
      ( self.parentMode, self.mapType, self.mapStr, self.pmapName,
        self.cmapName, self.aName ) = param
      self.modeKey = 'pmap-a'
      self.longModeKey = 'pmap-a-%s-%s-%s-%s' % \
            ( self.mapStr, self.pmapName, self.cmapName, self.aName )
      CliMode.ConfigMode.__init__(
            self, self.longModeKey, parentMode=self.parentMode )

class IdentityMapMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'identity map type dzgre'

   def __init__( self, param ):
      self.modeKey = 'identity-map'
      self.longModeKey = 'identity-map'
      CliMode.ConfigMode.__init__( self, param, parentMode=TapAggMode )
