# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class GlobalTeMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'router traffic-engineering'

   def __init__( self, param ):
      self.modeKey = "te"
      self.longModeKey = "te"
      CliMode.ConfigMode.__init__( self, param )

class FlexAlgoModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'flex-algo'

   def __init__( self, param ):
      self.modeKey = "flex-algo"
      self.longModeKey = "te-flex-algo"
      CliMode.ConfigMode.__init__( self, param, parentMode=GlobalTeMode )

class FlexAlgoDefModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'flex-algo %d %s' % ( self.algoId, self.name )

   def __init__( self, param ):
      self.algoId, self.name = param
      self.modeKey = "flex-algo-def"
      self.longModeKey = "te-flex-algo-def-%s" % self.name
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=FlexAlgoModeBase )
