# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode
import Tac

class TunnelProfilesBaseMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = "tunnel-profiles"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None )

   def enterCmd( self ):
      return "tunnel profiles"

class TunnelProfilesEncapTypeBaseMode( CliMode.ConfigMode ):
   def __init__( self, encapType ):
      self.modeKey = "tunnel-profiles-encap-type"
      self.longModeKey = f"{self.modeKey}-{encapType}"
      self.encapType = encapType
      CliMode.ConfigMode.__init__( self, encapType,
                                   parentMode=TunnelProfilesBaseMode )

   def enterCmd( self ):
      return f"encapsulation type {self.encapType}"

class TunnelProfilesTemplateBaseMode( CliMode.ConfigMode ):
   def __init__( self, encapTypeAndTemplateName ):
      self.encapType, self.templateName = encapTypeAndTemplateName
      self.modeKey = f"tunnel-profiles-encap-type-{self.encapType}-template"
      self.longModeKey = f"{self.modeKey}-{self.templateName}"
      CliMode.ConfigMode.__init__( self, encapTypeAndTemplateName,
                                   parentMode=TunnelProfilesEncapTypeBaseMode )

   def enterCmd( self ):
      return f"template {self.templateName}"

class TunnelProfilePolicyBaseMode( CliMode.ConfigMode ):
   def __init__( self, encapTypeAndPolicyName ):
      self.encapType, self.policyName = encapTypeAndPolicyName
      self.modeKey = f"tunnel-profiles-encap-type-{self.encapType}-policy"
      self.longModeKey = f"{self.modeKey}-{self.policyName}"
      CliMode.ConfigMode.__init__( self, encapTypeAndPolicyName,
                                   parentMode=TunnelProfilesEncapTypeBaseMode )

   def enterCmd( self ):
      return f"policy {self.policyName}"

class TunnelProfilePolicySeqBaseMode( CliMode.ConfigMode ):
   def __init__( self, policyNameAndSeqno ):
      self.policyName, self.seqno = policyNameAndSeqno
      self.modeKey = f"tunnel-profiles-policy-{self.policyName}-seq"
      self.longModeKey = f"{self.modeKey}-{self.seqno}"
      CliMode.ConfigMode.__init__( self, policyNameAndSeqno,
                                   parentMode=TunnelProfilePolicyBaseMode )

   def enterCmd( self ):
      return f"seq {self.seqno}"

