# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode
import Tac
from TypeFuture import TacLazyType

TunnelTableIdentifier = TacLazyType( "Tunnel::TunnelTable::TunnelTableIdentifier" )

class TunnelRibsBaseMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = "tunnel-ribs"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None )

   def enterCmd( self ):
      return self.modeKey

class TunnelRibBaseMode( CliMode.ConfigMode ):
   def __init__( self, tunnelRibName ):
      self.modeKey = "tunnel-rib"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "%s-%s" % ( self.modeKey, tunnelRibName )
      self.tunnelRibName = tunnelRibName
      CliMode.ConfigMode.__init__( self, tunnelRibName,
                                   parentMode=TunnelRibsBaseMode )

   def enterCmd( self ):
      if self.tunnelRibName == "system-colored-tunnel-rib":
         # pylint: disable-next=consider-using-f-string
         return "%s colored %s" % ( self.modeKey, self.tunnelRibName )
      else:
         # pylint: disable-next=consider-using-f-string
         return "%s %s" % ( self.modeKey, self.tunnelRibName )

_tunnelTables = { TunnelTableIdentifier.bgpLuTunnelTable: "bgp labeled-unicast",
                  TunnelTableIdentifier.srTunnelTable: "isis segment-routing",
                  TunnelTableIdentifier.ospfSrTunnelTable: "ospf segment-routing",
                  TunnelTableIdentifier.ldpTunnelTable: "ldp",
                  TunnelTableIdentifier.rsvpLerTunnelTable: "rsvp-ler",
                  TunnelTableIdentifier.nexthopGroupTunnelTable: "nexthop-group",
                  TunnelTableIdentifier.staticTunnelTable: "static",
                  TunnelTableIdentifier.isisFlexAlgoTunnelTable: "isis flex-algo",
                  TunnelTableIdentifier.srTePolicyTunnelTable: 
                     "segment-routing policy"
               }
# pylint: disable-next=consider-using-dict-comprehension
_reverseTunnelTables = dict( [ ( v.split()[ -1 ], k )
                               for k, v in _tunnelTables.items() ] )
# _reverseTunnelTables only generates dictionary based on single word ,
# so segment-routing gets mapped to srTunnelTable,
# OspfSrTunnelTable and srtePolicyTunnelTable so adding key's to add
# the different keys for these tunnel tables
_reverseTunnelTables['isis-segment-routing'] = TunnelTableIdentifier.srTunnelTable
_reverseTunnelTables['ospf-segment-routing'] = \
      TunnelTableIdentifier.ospfSrTunnelTable
_reverseTunnelTables['segment-routing-policy'] = \
      TunnelTableIdentifier.srTePolicyTunnelTable

def tunnelTableIdFromCliToken( cliToken ):
   return _reverseTunnelTables[ cliToken ]

def tunnelTableIdToCliToken( tunnelTableId ):
   return _tunnelTables[ tunnelTableId ]
