#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class LinkStateMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'link tracking group %s' % self.groupName_

   def __init__( self, param ):
      self.groupName_ = param
      self.modeKey = "link-state"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "link-state-%s" % self.groupName_
      CliMode.ConfigMode.__init__( self, self.groupName_ )
