#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.RouterGeneral import RouterGeneralBaseMode

class UrpfLooseModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'verify unicast source reachable-via any'

   def __init__( self, param ):
      self.modeKey = "router"
      self.longModeKey = "router-urpf-loose"
      CliMode.ConfigMode.__init__( self, param, parentMode=RouterGeneralBaseMode )

class UrpfStrictModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'verify unicast source reachable-via rx'

   def __init__( self, param ):
      self.modeKey = "router"
      self.longModeKey = "router-urpf-strict"
      CliMode.ConfigMode.__init__( self, param, parentMode=RouterGeneralBaseMode )
