#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class VirtualCableMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'virtual-cable'

   def __init__( self ):
      self.modeKey = "virtual-cable"
      self.longModeKey = "virtual-cable"
      CliMode.ConfigMode.__init__( self, self.longModeKey )

class VirtualCablePortMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'mux-port %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = "virtual-cable-mux-port"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "virtual-cable-mux-port-%s" % param
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )
