# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliParser
import CliMode
from CliMode.TrafficPolicy import ( MatchRuleBaseConfigMode,
                                    DefaultActionConfigModeBase,
                                    ActionsConfigModeBase,
                                    TrafficPolicyConfigModeBase )
from CliMode.Classification import FieldSetBasePrefixConfigMode

FEATURE = 'vrf-selection-policy'

class VrfSelectionMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = 'vrf-selection'
      self.longModeKey = 'vrf-selection'
      CliMode.ConfigMode.__init__( self, None )

   def enterCmd( self ):
      return "vrf selection policy"

class VrfSelectionConfigMode( BasicCli.ConfigModeBase, VrfSelectionMode ):
   name = 'VRF selection configuration'

   def __init__( self, parent, session ):
      VrfSelectionMode.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def abort( self ):
      # need empty method to allow for code sharing with Classification field-sets
      pass

   def commit( self ):
      # need empty method to allow for code sharing with Classification field-sets
      pass

class VrfSelectionPolicyConfigMode( TrafficPolicyConfigModeBase ):
   name = "VRF selection policy configuration"

   @property
   def configPolicyKeyword( self ):
      return 'policy'

# Match rule configuration mode
class VrfSelectionMatchIpv4RuleConfigMode( MatchRuleBaseConfigMode ):
   name = 'VRF selection policy IPv4 match rule configuration'

class VrfSelectionMatchIpv6RuleConfigMode( MatchRuleBaseConfigMode ):
   name = 'VRF selection policy IPv6 match rule configuration'

# Default actions configuration mode
class VrfSelectionDefaultIpv4ActionConfigMode(
      DefaultActionConfigModeBase ):
   name = '''VRF selection policy default IPv4 match rule actions configuration'''

class VrfSelectionDefaultIpv6ActionConfigMode(
      DefaultActionConfigModeBase ):
   name = '''VRF selection policy default IPv6 match rule actions configuration'''

# Action configuration mode
class VrfSelectionActionRuleConfigMode( ActionsConfigModeBase ):
   name = 'VRF selection policy action rule configuration'

class VrfSelectionIntfModelet( CliParser.Modelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      vrfSelectionIntfTypes = ( 'Ethernet', 'Port-Channel', 'Switch', )
      return mode.intf.name.startswith( vrfSelectionIntfTypes )

class VrfSelectionPolicyVrfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'vrf %s' % self.vrfName # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = 'vrf-selection'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'vrf-selection-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=VrfSelectionMode )

class VrfSelectionPolicyVrfConfigMode( BasicCli.ConfigModeBase,
                                       VrfSelectionPolicyVrfMode ):
   name = "VRF selection policy VRF configuration"

   def __init__( self, parent, session, vrfName ):
      VrfSelectionPolicyVrfMode.__init__( self, vrfName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class VrfSelectionFieldSetIpPrefixConfigMode( FieldSetBasePrefixConfigMode ):
   name = "vrf selection policy field-set ipv4 prefix configuration"

class VrfSelectionFieldSetIpv6PrefixConfigMode( FieldSetBasePrefixConfigMode ):
   name = "vrf selection policy field-set ipv6 prefix configuration"
