# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Monkey patch os.getuid and related APIs to keep it per-thread
def init():
   import errno # pylint: disable=import-outside-toplevel
   import os # pylint: disable=import-outside-toplevel
   import Syscall # pylint: disable=import-outside-toplevel

   os.getuid = Syscall.getuid
   os.geteuid = Syscall.geteuid
   os.getgid = Syscall.getgid
   os.getegid = Syscall.getegid

   # Disable setuid/seteuid

   # ConfigAgent allows temporary elevation to root privilege,
   # but we don't want anyone to call os.setuid/os.seteuid since
   # that breaks per-thread credentials. Let's just patch Python
   # to not allow os.setuid/seteuid to root.

   originalSetuid = os.setuid
   originalSeteuid = os.seteuid

   def _setuid( uid ):
      if uid == 0:
         raise OSError( errno.EPERM, os.strerror( errno.EPERM ) )
      return originalSetuid( uid )

   def _seteuid( euid ):
      if euid == 0:
         raise OSError( errno.EPERM, os.strerror( errno.EPERM ) )
      return originalSeteuid( euid )

   os.setuid = _setuid
   os.seteuid = _seteuid
