# Copyright (c) 2017-2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
#
# Monkey patch subprocess.Popen.__init__ to provide the correct parameters

import functools
import subprocess
import os
import sys

def patchPopenDefaults( f ):
   @functools.wraps( f )
   def wrapper( self, args, bufsize=-1, executable=None, stdin=None,
                stdout=None, stderr=None, preexec_fn=None,
                close_fds=True, shell=False, cwd=None, env=None,
                universal_newlines=None, startupinfo=None,
                creationflags=0, restore_signals=True,
                start_new_session=False, pass_fds=(), **kwargs ):
      if stdout is None:
         stdout = sys.stdout
      if stderr is None:
         stderr = sys.stderr
      if env is None:
         env = os.environ
      return f( self, args, bufsize, executable, stdin,
        stdout, stderr, preexec_fn, close_fds, shell,
        cwd, env, universal_newlines, startupinfo, creationflags,
        restore_signals, start_new_session, pass_fds, **kwargs )
   # pylint: disable=protected-access
   wrapper.__original = f
   return wrapper

def init():
   if not hasattr( subprocess.Popen.__init__, '__original' ):
      subprocess.Popen.__init__ = patchPopenDefaults( subprocess.Popen.__init__ )
