#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import AleCliLib
import BasicCliModes
import CliCommand
import CliParser
import CliToken.Ip
import CliToken.Hardware
import CliToken.Forwarding

# -------------------------------------------------------------------------------
# [ no | default ] ip hardware forwarding options action forward
# -------------------------------------------------------------------------------

def optionsGuard( mode, token ):
   if AleCliLib.routingHwStatus.ipOptionHwForwardingSupported:
      return None
   else:
      return CliParser.guardNotThisPlatform

nodeOptions = CliCommand.guardedKeyword(
   'options',
   helpdesc="Configure hardware forwarding for IPv4 options packet",
   guard=optionsGuard )

class IpHardwareForwardingOptionsCmd( CliCommand.CliCommandClass ):
   syntax = 'ip hardware forwarding options action forward'
   noOrDefaultSyntax = syntax
   data = {
         'ip': CliToken.Ip.ipMatcherForConfig,
         'hardware': CliToken.Hardware.hardwareMatcherForConfig,
         'forwarding': CliToken.Forwarding.forwardingMatcherForConfig,
         'options': nodeOptions,
         'action': 'Configure action on IPv4 options packet',
         'forward': 'Route IPv4 options packet in hardware'
         }

   handler = "AleL3IpOptionForwardingCliHandler.enableOptionsForwarding"
   noOrDefaultHandler = "AleL3IpOptionForwardingCliHandler.disableOptionsForwarding"

BasicCliModes.GlobalConfigMode.addCommandClass( IpHardwareForwardingOptionsCmd )
