# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
from CliMatcher import KeywordMatcher
from CliMatcher import EnumMatcher
from CliPlugin import AleL3UnicastShowCliModel
from CliPlugin.AleFibCli import l2AdjMatcher
import CliToken.Hardware
import CliToken.Ip
import CommonGuards
import ShowCommand

ipMatcherForShow = CliToken.Ip.ipMatcherForShow
hardwareMatcherForShow = CliToken.Hardware.hardwareMatcherForShow
aleKwForShow = CliCommand.guardedKeyword( 'ale',
      helpdesc="Ale-specific information",
      guard=CommonGuards.standbyGuard )
allKwMatcher = KeywordMatcher( 'all',
        helpdesc='Show all events' )
eventMatcherForShow = KeywordMatcher( 'event',
      helpdesc='Details related to ALE events' )
eventTypeMatcherForShow = CliCommand.Node( EnumMatcher(
    { 'bfd-down': 'BFD Down', 'link-down': 'Link Down',
        'tunnel-down': 'Tunnel Down' } ),
    maxMatches=1 )
statisticsMatcherForShow = KeywordMatcher( 'statistics',
      helpdesc='ALE statistics captured for easy debugging of churn during any '
            'degradation event such as interface down' )
summaryMatcher = KeywordMatcher( 'summary',
      helpdesc='ALE summary captured for easy debugging and monitoring' )
typeKwMatcher = KeywordMatcher( 'type',
        helpdesc='Show events based on type' )

# ---------------------------------------------------------------------------------
# "show ip hardware ale event [ type <TYPE> ] statistics [ all ]
# ---------------------------------------------------------------------------------

class ShowIpHardwareAleEventStatCmd( ShowCommand.ShowCliCommandClass ):
   syntax = ' show ip hardware ale event [ type TYPE ] statistics [ all ] '
   data = { 'ip': ipMatcherForShow,
         'hardware': hardwareMatcherForShow,
         'ale': aleKwForShow,
         'event': eventMatcherForShow,
         'type': typeKwMatcher,
         'TYPE': eventTypeMatcherForShow,
         'statistics': statisticsMatcherForShow,
         'all': allKwMatcher,
         }
   cliModel = AleL3UnicastShowCliModel.AleEventStatModel
   handler = "AleL3UnicastShowCliDynamicHandler.doShowAleEventStat"

BasicCli.addShowCommandClass( ShowIpHardwareAleEventStatCmd )

# ---------------------------------------------------------------------------------
# "show ip hardware ale l2-adj summary
# ---------------------------------------------------------------------------------

class ShowIpHardwareAleL2AdjSummaryCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip hardware ale l2-adj summary'
   data = { 'ip': ipMatcherForShow,
            'hardware': hardwareMatcherForShow,
            'ale': aleKwForShow,
            'l2-adj': l2AdjMatcher,
            'summary': summaryMatcher,
          }
   hidden = False
   cliModel = AleL3UnicastShowCliModel.AleL2AdjSummary
   handler = "AleL3UnicastShowCliDynamicHandler.doShowAleL2AdjSummary"

BasicCli.addShowCommandClass( ShowIpHardwareAleL2AdjSummaryCmd )
