# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac
from CliPlugin.AleFibCliModel import routeTypeEnum
from CliModel import (
      Dict,
      DeferredModel,
      Enum,
      Float,
      Int,
      List,
      Str,
   )

aleEventStatTypeEnum = ( 'linkDown', 'bfdDown', 'tunnelDown', 'fibFecUpdate',
      'fibTunnelUpdate', 'fibRouteUpdate', 'hwInducedPrefixWalk' )

class AleOverlappingEventInfo( DeferredModel ):
   __public__ = False
   eventType = Enum( values=aleEventStatTypeEnum, help='Specifies event type' )
   eventCount = Int( help="Number of times the event occurred" )

class AleFecMaxPrefixKeyInfo( DeferredModel ):
   __public__ = False
   parentPrefixCount = Int( help='Total prefixes scheduled by the adjacency per '
         'review cycle' )
   parentAdjCount = Int( help='Total hierarchical parents for the L3 adjacency' )

class AleL2AdjEventStatCounterInfo( DeferredModel ):
   __public__ = False
   routeType = Enum( values=routeTypeEnum, help='Route type' )
   created = Int( help='Total L2 adjacencies created' )
   deleted = Int( help='Total L2 adjacencies deleted' )
   modified = Int( help='Total L2 adjacencies modified' )

class AleEventStatInfo( DeferredModel ):
   __public__ = False
   eventSource = Str( help='Event interface/tunnel ID' )
   eventType = Enum( values=aleEventStatTypeEnum, help='Specifies event type' )
   startTimestamp = Float( help='Event start timestamp' )
   l2AdjacencyReviewEnd = Float(
         help='Timestamp when L2 adjacency monitor review queue was drained' )
   l3AdjacencyReviewEnd = Float( optional=True,
         help='Timestamp when high priority L3 adjacency queue was drained of all '
              'entries' )
   dampenedL3AdjacencyReviewEnd = Float( optional=True,
         help='Timestamp when high priority dampened L3 adjacency queue was drained '
              'of all entries' )
   dropUnknownL2AdjWithdrawn = Float(
         help='Timestamp when all drop/unknown L2 adjacencies entries added, during '
              'event timeframe, were withdrawn' )
   overlappingEvents = List( valueType=AleOverlappingEventInfo, optional=True,
         help='Overlapping event, with count for each, that caused churn in the '
              'system' )
   routesReviewed = Int( help='Total routes reviewed' )
   l3AdjacenciesReviewed = Int( help='Total L3 adjacencies reviewed' )
   dampL3AdjacenciesReviewed = Int( help='Total dampened L3 adjacencies reviewed' )
   l2AdjacenciesReviewed = Int( help='Total L2 adjacencies reviewed' )
   dropFecsProgrammed = Int( help='Total drop FEC installed' )
   prefixWalkCount = Int( help='Total prefix walks triggered' )
   fecMaxPrefixes = Dict( keyType=int, valueType=AleFecMaxPrefixKeyInfo,
         optional=True,
         help='Top 10 adjacencies scheduling the highest number of prefixes for '
              'review' )
   l2AdjacencyEventCounters = List( valueType=AleL2AdjEventStatCounterInfo,
         optional=True,
         help='L2 adjacency counters classified based on route type' )

class AleEventStatModel( DeferredModel ):
   __public__ = False
   cmdErr = Str( optional=True, help='Error message' )
   events = List( valueType=AleEventStatInfo, optional=True,
         help="List of event stats" )

class AleL2AdjSummary( DeferredModel ):
   total = Int( help="Total number of l2-adjacencies" )
   flattenedDown = Int( help="Number of flattened down l2-adjacencies" )
   flatteningIncorporated = Int(
         help="Number of flattening-incorporated l2-adjacencies" )
   ecmpUcmp = Int( help="Number of ECMP/UCMP l2-adjacencies" )
   arpRequired = Int( help="Number of l2-adjacencies containing ArpRequired via" )
   flood = Int( help="Number of l2-adjacencies containing flooding via" )
   backupActivated = Int( help="Number of l2-adjacencies with backup activated" )
   proxySource = Int( help="Number of proxied source l2-adjacencies" )
   proxyRef = Int( help="Number of proxy references to l2-adjacencies" )
   subOptimal = Int( help="Number of sub-optimal l2-adjacencies" )
   requestStateCounts = Dict( keyType=str, valueType=int,
         help="l2-adjacencies counts per Request State" )
   hardwareStateCounts = Dict( keyType=str, valueType=int,
         help="l2-adjacencies counts per Hadrware State" )
   forwardingStateCounts = Dict( keyType=str, valueType=int,
         help="l2-adjacencies counts per Forwarding State" )
   depthCounts = Dict( keyType=str, valueType=int,
         help="l2-adjacencies counts per Depth level" )
   heightCounts = Dict( keyType=str, valueType=int,
         help="l2-adjacencies counts per Height level" )
   __public__ = False
