#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import AleCountersCli, TechSupportCli
from TypeFuture import TacLazyType

def _showTechGuard():
   MplsTunnelFeatureId = TacLazyType( 'FlexCounters::FeatureId' ).MplsTunnel
   return ( AleCountersCli.checkCounterFeatureSupported( MplsTunnelFeatureId ) and
            AleCountersCli.checkCounterFeatureConfigured( MplsTunnelFeatureId ) )

TechSupportCli.registerShowTechSupportCmd(
   '2021-11-02 09:34:32',
   cmds=[
      'show mpls tunnel counters',
   ],
   cmdsGuard=_showTechGuard )
