# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ArnetModel import IpGenericAddress, MacAddress
from CliModel import DeferredModel, Dict, Int, List, Bool, Str, Model
from IntfModels import Interface

# Since the necessary collections are in Stash, which does not currently support
# Python in terms of destashing and reading from within Python ConfigAgent, we must
# implement the CLI in C++ using ACR.
# ACR commands requires us to use DeferredModel instead of Model
# GHC Link:
# https://mail.google.com/chat/#chat/space/AAAAVPoHyw4/7hEE2KdZlM4
class AleOpenConfigExportedNextHop( Model ):
   ipAddress = IpGenericAddress( help="IP address" )
   macAddress = MacAddress( help="MAC address" )
   interface = Interface( help="Interface" )
   labels = List( help="MPLS labels", valueType=int, optional=True )
   popTopLabel = Bool( help="Pop the top label from the MPLS label stack" )
   weight = Int( help="Next hop weight" )

class AleOpenConfigExportedFec( Model ):
   programmedId = Int( help="Exported programmed ID" )
   nextHops = Dict( help="A mapping of next-hops IDs to exported next-hop"
                         " information",
                    keyType=int,
                    valueType=AleOpenConfigExportedNextHop )

class AleOpenConfigExport( DeferredModel ):
   cmdErr = Str( help="Error message", optional=True )
   fecs = Dict( help="A mapping of FEC IDs to exported FEC information",
                valueType=AleOpenConfigExportedFec,
                keyType=int,
                optional=True )
