# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def vtepsInSystem( vxlanHwStatusDir, aleVxlanHwHerVtepStatusDir,
                   vtepHwStatusDir=None ):
   # scan through various source of VTEP ip addresses and create a union set
   # assuming that VTEP ip address when present in multiple sources
   # refers to the same remote VTEP
   remoteVteps = set()

   if vxlanHwStatusDir:
      vtiIntfIds = list( vxlanHwStatusDir.vxlanHwStatus )
      for vtiIntfId in vtiIntfIds:
         remoteVteps = remoteVteps.union( 
            set( vxlanHwStatusDir.vxlanHwStatus[ vtiIntfId ].remoteVtep.keys() ) )

   if aleVxlanHwHerVtepStatusDir:
      remoteVteps = remoteVteps.union(
         set( aleVxlanHwHerVtepStatusDir.aleVxlanHwHerVtepStatus ) )

   if vtepHwStatusDir:
      for vtepHwStatus in vtepHwStatusDir.vtepStatus.values():
         remoteVteps = remoteVteps.union( set( vtepHwStatus.vtepList ) )

   return remoteVteps

def vnisInSystem( vtiStatusDir ):
   # scan through various source of VNI and create a union set
   # assuming that VNI when present in multiple sources refers to the same VNI
   vnis = set()
   if vtiStatusDir:
      for vtiStatus in vtiStatusDir.vtiStatus.values():
         vlanVniMap = vtiStatus.vlanToVniMap
         for vlan in vlanVniMap:
            vnis.add( vlanVniMap[ vlan ].vni )
   return vnis

