# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import CliParser
import CliToken.Monitor
import ConfigMount
import LazyMount
import Tac
import Tracing
# pkgdeps: import ApcaLib

t0 = Tracing.Handle( "ApcaCli" ).trace0

hwCapability = None
cliFlowConfig = None
mirroringConfig = None

def captureSupportedGuard( mode, token ):
   return flowSupportedGuard( mode, token )

def flowSupportedGuard( mode, token ):
   supported = hwCapability.ipv4FlowSupported or hwCapability.ipv6FlowSupported
   if supported:
      return None
   return CliParser.guardNotThisPlatform

def ipv4FlowSupportedGuard( mode, token ):
   supported = hwCapability.ipv4FlowSupported
   if supported:
      return None
   return CliParser.guardNotThisPlatform

def ipv6FlowSupportedGuard( mode, token ):
   supported = hwCapability.ipv6FlowSupported
   if supported:
      return None
   return CliParser.guardNotThisPlatform

def handleEnableFlows( mode, args ):
   disable = CliCommand.isNoOrDefaultCmd( args )
   enableIpv4Flows = args.get( 'ipv4' )
   enableIpv6Flows = args.get( 'ipv6' )
   if enableIpv4Flows:
      cliFlowConfig.enableIpv4 = not disable
   if enableIpv6Flows:
      cliFlowConfig.enableIpv6 = not disable

# -----------------------------------------------------------------------------------
# [no|default] apca flow enable [ipv4|ipv6|all]
# ----------------------------------------------------------------------------------
class ApcaFlowEnableCmd( CliCommand.CliCommandClass ):
   syntax = """monitor flow capture type ( ipv4 | ipv6 )"""
   noOrDefaultSyntax = """monitor flow capture type ( ipv4 | ipv6 )"""
   data = {
         "monitor": CliToken.Monitor.monitorMatcher,
         "flow": CliCommand.Node( matcher=CliMatcher.KeywordMatcher( "flow",
                                             helpdesc="Flow capture configuration" ),
                                  guard=flowSupportedGuard, hidden=True ),
         "capture": CliCommand.Node( matcher=CliMatcher.KeywordMatcher( "capture",
                              helpdesc="Packet capture and analysis configuration" ),
                              guard=captureSupportedGuard ),
         "type": "Enable creation of flows",
         "ipv4": CliCommand.Node( matcher=CliMatcher.KeywordMatcher(
                        "ipv4",
                        helpdesc="Enable creation of ipv4 flows" ),
                        guard=ipv4FlowSupportedGuard ),
         "ipv6": CliCommand.Node( matcher=CliMatcher.KeywordMatcher(
                        "ipv6",
                        helpdesc="Enable creation of ipv6 flows" ),
                        guard=ipv6FlowSupportedGuard ),
         }
   handler = handleEnableFlows
   noOrDefaultHandler = handleEnableFlows

BasicCli.GlobalConfigMode.addCommandClass( ApcaFlowEnableCmd )

def Plugin( entMan ):
   global cliFlowConfig, hwCapability, mirroringConfig

   hwCapability = ConfigMount.mount( entMan, "apca/hwcapability",
                                     "Apca::HwCapability", "w" )
   cliFlowConfig = ConfigMount.mount( entMan, "apca/cliflowconfig",
                                      "Apca::CaptureFlowHwConfig", "w" )
   mirroringConfig = LazyMount.mount( entMan, "mirroring/hwconfig",
                                      "Mirroring::Config", "r" )
