# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing

traceHandle = Tracing.Handle( 'ArBgpCli' )
t1 = traceHandle.trace1

# a global that holds the extended community parsing state machinery
# the Evpn plugin accesses this state machine to set up additional parsing rules for
# Evpn extended communities.
# The extCommParser will be used by CliPlugins for rendering extended communities
# from their U64 representations.
bgpExtCommParserContainerSm = None

def getBgpExtCommParserContainerSm():
   global bgpExtCommParserContainerSm
   if bgpExtCommParserContainerSm is None:
      bgpExtCommParserContainerSm = Tac.newInstance(
            "Routing::Bgp::BgpParseExtCommContainerSm" )
      t1( 'getBgpExtCommParserContainerSm: created bgpExtCommParserContainerSm' )
   return bgpExtCommParserContainerSm

def doShowBgpDisabled( mode, vrfName ): # pylint: disable=useless-return
   # pylint: disable-next=consider-using-f-string
   mode.addWarning( 'BGP is disabled for VRF %s' % vrfName )
   return None
