# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliPlugin.MplsCli import (
      mplsNodeForShow,
      bindingsKw,
)
from CliPlugin import IpAddrMatcher
from CliPlugin.MplsModel import MplsBindingsModel
from CliToken.RoutingBgpShowCliTokens import (
      bgpAfterShow,
      detail,
      labeledUnicastAfterShowBgp,
      summaryGeneric,
)
import ShowCommand

#--------------------------------------------------------------------------------
# show mpls bgp labeled-unicast bindings [ PREFIX ] [ detail | summary ]
#--------------------------------------------------------------------------------
class ShowMplsBgpLuBindingsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mpls bgp labeled-unicast bindings [ PREFIX ] [ detail | summary ]'
   data = {
      'mpls' : mplsNodeForShow,
      'bgp' : bgpAfterShow,
      'labeled-unicast' : labeledUnicastAfterShowBgp,
      'bindings' : bindingsKw,
      'PREFIX' : IpAddrMatcher.ipPrefixExpr(
         'Network address', 'Network mask', 'Address',
         overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO ),
      'detail' : detail,
      'summary' : summaryGeneric,
   }
   cliModel = MplsBindingsModel

   handler = "ArBgpLuCliHandler.showMplsBgpLuBindingsCmdHandler"

BasicCli.addShowCommandClass( ShowMplsBgpLuBindingsCmd )
