# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliPlugin.BridgingEtbaCli import tfaNodeUnguarded
from CliToken.Platform import platformMatcherForShow
from ShowCommand import ShowCliCommandClass

class ShowPlatformTfaTrafficPolicyIntfSummary( ShowCliCommandClass ):
   syntax = 'show platform tfa traffic-policy interface summary'
   data = {
      'platform': platformMatcherForShow,
      'tfa': tfaNodeUnguarded,
      'traffic-policy': 'Traffic policy information',
      'interface': 'Traffic policy applied to interfaces',
      'summary': 'Hardware usage summary',
   }

   handler = 'ArfaAegisShowCliHandler.doShowPlatformTfaTpIntfSummary'
   privileged = True

BasicCli.addShowCommandClass( ShowPlatformTfaTrafficPolicyIntfSummary )
